Attribute VB_Name = "modCDTest"
'////////////////////////////////////////////////////////////////////
' modCDTest.bas - Copyright (c) 2003 JOBnik! [Arthur Aminov, ISRAEL]
'                                    e-mail: jobnik2k@hotmail.com
' Other source: frmCDTest.frm
'
' BASSCD Test
' Originally Translated from: - cdtest.c - Example of Ian Luck
'////////////////////////////////////////////////////////////////////

Public Const MAXDRIVES = 10
Public curdrive As Long
Public stream(MAXDRIVES) As Long
Public seeking As Long

' End sync
Public Sub EndSync(ByVal handle As Long, ByVal channel As Long, ByVal data As Long, ByVal user As Long)
    If (frmCDTest.chkAdvance.value) Then  ' advance onto next track
        Dim track As Long, drive As Long
        track = BASS_CD_StreamGetTrack(channel)
        drive = HiWord(track)
        track = (LoWord(track) + 1) Mod BASS_CD_GetTracks(drive)
        If (drive = curdrive) Then frmCDTest.lstTracks.ListIndex = track
        Call PlayTrack(drive, track)
    End If
End Sub

Public Sub PlayTrack(ByVal drive As Long, ByVal track As Long)
    On Error Resume Next    'to skip .sldPos.max error if stream(drive)=0
    stream(drive) = BASS_CD_StreamCreate(drive, track, BASS_CD_FREEOLD)  ' create stream
    Call BASS_ChannelSetSync(stream(drive), BASS_SYNC_END, 0, AddressOf EndSync, 0) ' set end sync
    If (drive = curdrive) Then
        With frmCDTest
            .sldPos.max = (BASS_StreamGetLength(stream(drive)) / 176400) - 1 ' set pos scroller range
            .sldVol.value = 0  ' set default volume slider pos
            .sldSpeed.value = 100 ' set default speed slider pos
            .frameCDTest(1).Caption = " Speed - 100% "
        End With
    End If
    Call BASS_StreamPlay(stream(drive), 0, 0) ' start playing
End Sub

Public Sub UpdateTrackList()
    Dim a As Long, tc As Long, l As Long, cdtext As Long, text As String
    
    tc = BASS_CD_GetTracks(curdrive)
    frmCDTest.lstTracks.Clear
    
    If (tc = -1) Then Exit Sub  'no CD
    
    cdtext = BASS_CD_GetID(curdrive, BASS_CDID_TEXT) 'get CD-TEXT
    
    For a = 0 To tc - 1
        l = BASS_CD_GetTrackLength(curdrive, a)
        text = "Track " & Format(a + 1, "00")
        If (cdtext) Then
            Dim t As Long, tag As String
            t = cdtext
            tag = "TITLE" & a + 1 & "="  'the CD-TEXT tag to look for
            Do
                If (Mid(VBStrFromAnsiPtr(t), 1, Len(tag)) = tag) Then 'found the track title...
                    text = VBStrFromAnsiPtr(t + Len(tag)) 'replace "track x" with title
                    Exit Do
                End If
                t = t + Len(VBStrFromAnsiPtr(t)) + 1
            Loop While (VBStrFromAnsiPtr(t) <> "")
        End If
        If (l = -1) Then
            text = text & " (data)"
        Else
            l = l / 176400
            text = text & " (" & CInt(l / 60) & ":" & Format(CInt(l Mod 60), "00") & ")"
        End If
        
        frmCDTest.lstTracks.AddItem text
    Next a
    
    a = BASS_CD_StreamGetTrack(stream(curdrive))
    If (a <> -1) Then ' this drive has a stream
        Dim vol As Long, spd As Long
        With frmCDTest
            .lstTracks.ListIndex = LoWord(a) ' select current track
            .sldPos.max = (BASS_StreamGetLength(stream(curdrive)) / 176400) - 1 ' set pos scroller range
            Call BASS_ChannelGetAttributes(stream(curdrive), spd, vol, 0) ' get speed & volume
            .sldVol.value = 100 - vol ' set volume slider pos
            .sldSpeed.value = spd / 441 ' set speed slider pos
            .frameCDTest(1).Caption = " Speed - " & spd / 441 & "% "
        End With
    Else
        frmCDTest.frameCDTest(1).Caption = " Speed "
    End If
End Sub
